/**
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/SendEmailAttachment'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./SendEmailAttachment'));
  } else {
    // Browser globals (root is window)
    if (!root.SibApiV3Sdk) {
      root.SibApiV3Sdk = {};
    }
    root.SibApiV3Sdk.SendEmail = factory(root.SibApiV3Sdk.ApiClient, root.SibApiV3Sdk.SendEmailAttachment);
  }
}(this, function(ApiClient, SendEmailAttachment) {
  'use strict';




  /**
   * The SendEmail model module.
   * @module model/SendEmail
   * @version 8.2.0
   */

  /**
   * Constructs a new <code>SendEmail</code>.
   * @alias module:model/SendEmail
   * @class
   * @param emailTo {Array.<String>} List of the email addresses of the recipients. For example, ['abc@example.com', 'asd@example.com'].
   */
  var exports = function(emailTo) {
    var _this = this;

    _this['emailTo'] = emailTo;








  };

  /**
   * Constructs a <code>SendEmail</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/SendEmail} obj Optional instance to populate.
   * @return {module:model/SendEmail} The populated <code>SendEmail</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('emailTo')) {
        obj['emailTo'] = ApiClient.convertToType(data['emailTo'], ['String']);
      }
      if (data.hasOwnProperty('emailBcc')) {
        obj['emailBcc'] = ApiClient.convertToType(data['emailBcc'], ['String']);
      }
      if (data.hasOwnProperty('emailCc')) {
        obj['emailCc'] = ApiClient.convertToType(data['emailCc'], ['String']);
      }
      if (data.hasOwnProperty('replyTo')) {
        obj['replyTo'] = ApiClient.convertToType(data['replyTo'], 'String');
      }
      if (data.hasOwnProperty('attachmentUrl')) {
        obj['attachmentUrl'] = ApiClient.convertToType(data['attachmentUrl'], 'String');
      }
      if (data.hasOwnProperty('attachment')) {
        obj['attachment'] = ApiClient.convertToType(data['attachment'], [SendEmailAttachment]);
      }
      if (data.hasOwnProperty('headers')) {
        obj['headers'] = ApiClient.convertToType(data['headers'], Object);
      }
      if (data.hasOwnProperty('attributes')) {
        obj['attributes'] = ApiClient.convertToType(data['attributes'], Object);
      }
      if (data.hasOwnProperty('tags')) {
        obj['tags'] = ApiClient.convertToType(data['tags'], ['String']);
      }
    }
    return obj;
  }

  /**
   * List of the email addresses of the recipients. For example, ['abc@example.com', 'asd@example.com'].
   * @member {Array.<String>} emailTo
   */
  exports.prototype['emailTo'] = undefined;
  /**
   * List of the email addresses of the recipients in bcc
   * @member {Array.<String>} emailBcc
   */
  exports.prototype['emailBcc'] = undefined;
  /**
   * List of the email addresses of the recipients in cc
   * @member {Array.<String>} emailCc
   */
  exports.prototype['emailCc'] = undefined;
  /**
   * Email address which shall be used by campaign recipients to reply back
   * @member {String} replyTo
   */
  exports.prototype['replyTo'] = undefined;
  /**
   * Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps
   * @member {String} attachmentUrl
   */
  exports.prototype['attachmentUrl'] = undefined;
  /**
   * Pass the list of content (base64 encoded) and name of the attachment. For example, [{\"content\":\"base64 encoded content 1\", \"name\":\"attcahment1\"}, {\"content\":\"base64 encoded content 2\", \"name\":\"attcahment2\"}].
   * @member {Array.<module:model/SendEmailAttachment>} attachment
   */
  exports.prototype['attachment'] = undefined;
  /**
   * Pass the set of headers that shall be sent along the mail headers in the original email. 'sender.ip' header can be set (only for dedicated ip users) to mention the IP to be used for sending transactional emails. Headers are allowed in `This-Case-Only` (i.e. words separated by hyphen with first letter of each word in capital letter), they will be converted to such case styling if not in this format in the request payload. For example, {\"Content-Type\":\"text/html\", \"charset\":\"iso-8859-1\", \"sender.ip\":\"1.2.3.4\"}
   * @member {Object} headers
   */
  exports.prototype['headers'] = undefined;
  /**
   * Pass the set of attributes to customize the template. For example, {\"FNAME\":\"Joe\", \"LNAME\":\"Doe\"}
   * @member {Object} attributes
   */
  exports.prototype['attributes'] = undefined;
  /**
   * Tag your emails to find them more easily
   * @member {Array.<String>} tags
   */
  exports.prototype['tags'] = undefined;



  return exports;
}));


