var express = require('express');
router = express.Router();
var jwt = require('jsonwebtoken');

process.env.SECRET_KEY = "thisismysecretkey";

var isLoggedIn = function (req, res, next) {
    // console.log("venki",req.headers);

    var token = req.body.token || req.headers['token'];
    if (token) {
        jwt.verify(token, process.env.SECRET_KEY, function (err, ress) {
            if (err) {
                // res.status(500).send('Token Invalid');
                res.send({ "status": 201, "message": 'Token Invalid' });
            } else {
                next();
            }
        })
    } else {
        res.send(201, 'Please send a token');
    }
}

//Include Controller
var sampleRoutes = require('../controllers/mainCtrl');

router.post('/newuserlogin', sampleRoutes.newuserloginCtrl);		// login
router.post('/newusersignup', sampleRoutes.newusersignupCtrl);		// Signup
router.post('/continents', sampleRoutes.continentsCtrl);		// continents
router.post('/countries', sampleRoutes.countriesCtrl);		// continents
router.post('/sections', sampleRoutes.sectionsCtrl);		// sections
router.post('/chapters', sampleRoutes.chaptersCtrl);		// sections
router.post('/leadcategories', sampleRoutes.leadcategoriesCtrl);// leadcategorie
router.post('/currencies', sampleRoutes.currenciesCtrl);// currencies
router.post('/postleaddata', sampleRoutes.postleaddataCtrl);// LEADDATA
router.post('/allcountries', sampleRoutes.allcountriesCtrl);		// all_countries
router.post('/states', sampleRoutes.statesCtrl);		// states
router.post('/postagencydata', sampleRoutes.postagencydataCtrl);// AGENCY DATA
router.post('/postfranchisedata', sampleRoutes.postfranchisedataCtrl);// FRANCHISE DATA 
router.post('/getporttype', sampleRoutes.getporttypeCtrl);// port type DATA
router.post('/selectedports', sampleRoutes.selectedportsCtrl);// Selectedports DATA 
router.post('/hscodesdata', sampleRoutes.hscodesdataCtrl);// hscodesdata DATA
router.post('/getsearchdata', sampleRoutes.getsearchdataCtrl);// searchdata DATA
router.post('/check_franchise', sampleRoutes.check_franchiseCtrl);// Franchise Eligibility DATA
router.post('/postleaddataMbl', sampleRoutes.postleaddataMblCtrl);// LEADDATA MOBILE
router.post('/dontknowhscode', sampleRoutes.dontknowhscodeCtrl);// dontknowhscode MOBILE
router.post('/membershipdtls_description', sampleRoutes.membershipdtls_descriptionCtrl);// membershipdtls
router.post('/postmembershipdetails', sampleRoutes.postmembershipdetailsCtrl);// post membershipdtls

router.post('/getmembershipdtls', sampleRoutes.getmembershipdtlsCtrl);//get membershipdtls

router.post('/addfovourites', sampleRoutes.addfovouritesCtrl);//addfovourites
router.post('/removefovourites', sampleRoutes.removefovouritesCtrl);//removefovourites
router.post('/getfavourites', sampleRoutes.getfavouritesCtrl);//getfavourites
router.post('/getleadcntchapters', sampleRoutes.getleadcntchaptersCtrl);//getleadcntchapters

router.post('/getleaddetails', sampleRoutes.getleaddetailsCtrl);//getleaddetails
router.post('/postrequestquote', sampleRoutes.postrequestquoteCtrl);//postrequestquote
router.post('/getrequestquote', sampleRoutes.getrequestquoteCtrl);//getrequestquote
router.post('/addhscode', sampleRoutes.addhscodeCtrl);//addhscode
// router.get('/generateleaddisplayId', sampleRoutes.generateleaddisplayIdCtrl);//generateleaddisplayId
router.post('/getsliders', sampleRoutes.getslidersCtrl);//getsliders

router.get('/email', sampleRoutes.emailctrl);//email
router.post('/deleteUser', sampleRoutes.deleteUserCtrl); 









  //dashboard api start
  
  // Faizullah Google-Auth Apis Start
  
router.post('/register',  sampleRoutes.registerUserCtrl);     

router.post('/login',  sampleRoutes.loginUserCtrl);      

router.post('/tfa/setup',  sampleRoutes.gettfaCtrl);   

router.post('/tfa/setups',  sampleRoutes.posttfaCtrl);   

router.post('/tfa/delete',  sampleRoutes.deletetfaCtrl);   

router.post('/tfa/verify',  sampleRoutes.verifytfaCtrl);   

   // Faizullah Google-Auth Apis End
  

router.post('/getallusers', sampleRoutes.getallusersCtrl);//getallusers
router.post('/deleteuser', sampleRoutes.deleteuserCtrl);//deleteuser
router.post('/getallagencies', sampleRoutes.getallagenciesCtrl);//getallagencies
router.post('/postapprovedata', sampleRoutes.postapprovedataCtrl);//postapprovedata

router.post('/userData', sampleRoutes.getuserDataCtrl);// EditProfile DATA
router.post('/userprofiledata', sampleRoutes.userprofiledataCtrl);
router.post('/getviewpackagedeatils', sampleRoutes.getviewpackagedeatilsCtrl);
router.post('/getusersectionsdata', sampleRoutes.getusersectionsdataCtrl);
router.post('/updateprofileImage', sampleRoutes.updateprofileImageCtrl);
router.post('/updateviewcreditsdata', sampleRoutes.updateviewcreditsdataCtrl);
router.post('/getsubscriptiondata', sampleRoutes.getsubscriptiondataCtrl);
router.post('/getusingleads', sampleRoutes.getusingleadsCtrl);
router.post('/gethscodesdata', sampleRoutes.gethscodesdataCtrl);
router.post('/getagencydetailsdata', sampleRoutes.getagencydetailsCtrl); 
router.post('/getbuyerdetailsdata', sampleRoutes.getbuyerdetailsdataCtrl); 

router.post('/gethsrmdaatdetails', sampleRoutes.gethsrmdaatdetailsCtrl);
  //dashboard api end
  router.post('/getchatgroupdata', sampleRoutes.getchatgroupdataCtrl);
//04/12/2021
router.post('/getCountryid', sampleRoutes.getCountryidCtrl);
router.post('/getCountryidweb', sampleRoutes.getCountryidwebCtrl);

  //agent board api start
router.get('/verificationmail/:id', sampleRoutes.verificationmailCtrl);
  //verificationmail
router.post('/submitipdetails', sampleRoutes.submitipdetailsCtrl);//submitipdtls
router.post('/forgetpassword', sampleRoutes.forgetpasswordCtrl);//forgetpassword
router.post('/bulkusersupload', sampleRoutes.bulkusersuploadCtrl);
router.post('/getagentbasedusers', sampleRoutes.getagentbasedusersCtrl);
//09/12/2021
router.post('/updatepublicplayerid', sampleRoutes.updatepublicplayeridCtrl);
router.post('/postAfterSuccess', sampleRoutes.postAfterSuccessCtrl);
router.get('/getmobilesvrvisionmeetingapi', sampleRoutes.getAdminInitiatiteMeetingDltsCtrl);
// getAllInitiatedMeetings
router.get('/getAllInitiatedMeetings', sampleRoutes.getAllInitiatedMeetingsCtrl);
router.post('/postremainderleaddata', sampleRoutes.postremainderleaddataCtrl);
router.post('/postpolicydata', sampleRoutes.postpolicydataCtrl);

router.post('/postrfqdata', sampleRoutes.postrfqdataCtrl);
router.post('/getpolicyurldata', sampleRoutes.getpolicyurldataCtrl);
router.post('/getrfqreuesteddata', sampleRoutes.getrfqreuesteddataCtrl);
router.post('/getadminaccountsdata', sampleRoutes.getadminaccountsdataCtrl);
router.post('/getagentaccountsdata', sampleRoutes.getagentaccountsdataCtrl);
router.post('/getagentusersdata', sampleRoutes.getagentusersdataCtrl);


router.post('/postwelcomemessage', sampleRoutes.postwelcomemessageCtrl);
router.post('/flagsdata', sampleRoutes.flagsdataCtrl);
router.post('/serviceprovider', sampleRoutes.serviceproviderCtrl);
router.post('/posteditprofile', sampleRoutes.posteditprofileCtrl);
router.post('/postholdeddata', sampleRoutes.postholdeddataCtrl);
router.post('/postsupportdata', sampleRoutes.postsupportdataCtrl);
router.post('/getsupportdata', sampleRoutes.getsupportdataCtrl);
router.post('/postenquiry', sampleRoutes.postenquiryCtrl);
router.post('/certifyingagencies', sampleRoutes.certifyingagenciesCtrl);
router.post('/removechatgroupfromchat', sampleRoutes.removechatgroupfromchatCtrl);
router.post('/getrestrictiondata', sampleRoutes.getrestrictiondataCtrl);
router.post('/sendmailaddedhscodes', sampleRoutes.sendmailaddedhscodesCtrl);
router.post('/aprvaddedhscodes', sampleRoutes.aprvaddedhscodesCtrl);
router.post('/sendmailrfqapproval', sampleRoutes.sendmailrfqapprovalCtrl); 
router.post('/getfrqreuesteddata', sampleRoutes.getfrqreuesteddataCtrl); 
router.post('/editsubscriptionplan', sampleRoutes.editsubscriptionplanCtrl);
router.post('/getenquirydata', sampleRoutes.getenquirydataCtrl);
router.post('/usreditedbyadmin', sampleRoutes.usreditedbyadminCtrl);
router.post('/getagentpayoutdata', sampleRoutes.getagentpayoutdataCtrl);
router.post('/getagentslabcommdata', sampleRoutes.getagentslabcommdataCtrl);
router.post('/agenteditbyadmin2', sampleRoutes.agenteditbyadminCtrl);
router.post('/franchiseeditbyadmin2', sampleRoutes.franchiseeditbyadmin2Ctrl);
router.post('/getfranchiseusers', sampleRoutes.getfranchiseusersCtrl);
router.post('/getfranchiseleads', sampleRoutes.getfranchiseleadsCtrl);
router.post('/getagentleads', sampleRoutes.getagentleadsCtrl);

router.post('/getfranchiseaccountsdata', sampleRoutes.getfranchiseaccountsdataCtrl);
router.post('/getfranchisepayoutdata', sampleRoutes.getfranchisepayoutdataCtrl);

router.post('/getagentmobilelogin', sampleRoutes.getagentmobileloginCtrl);
router.post('/geteximdata', sampleRoutes.geteximdataCtrl);
router.post('/postappdemovideos', sampleRoutes.postappdemovideosCtrl);
router.post('/createinternallogins', sampleRoutes.createinternalloginsCtrl);
router.post('/bulkemailsender', sampleRoutes.bulkemailsenderCtrl);
router.post('/bannerdata', sampleRoutes.bannerdataCtrl);
router.post('/postleademailauthentication', sampleRoutes.postleademailauthenticationCtrl);
router.post('/validationotp', sampleRoutes.validationotpCtrl);
router.post('/leadeditedbyadmin', sampleRoutes.leadeditedbyadminCtrl);



























module.exports = router;
